#version 120
varying vec4 texcoord;
varying vec4 color;
varying vec4 lmcoord;
uniform float frameTimeCounter;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

attribute vec4 mc_Entity;

float curve(float x)
{
	return tan(x);
}

float invcurve(float x, float curvature)
{
	return atan(x/curvature)*curvature;
}

void main() {
	vec4 position = gl_ModelViewMatrix * gl_Vertex;
	position = gbufferModelViewInverse * position;
	float curvature = 256;
	float dist = sqrt(position.z*position.z + position.x*position.x);

	float oma = curve(dist / curvature);
	float z = invcurve(position.z, curvature);
	float x = invcurve(position.x, curvature);
	float y = position.y;
	if(mc_Entity.x == 9){
		y += sin(frameTimeCounter+z-x)/10;
	}
	float xy = invcurve(dist, curvature);
	position.y = (xy*oma+y);
	position.x = x;
	position.z = z;

	position = gbufferModelView * position;
	gl_Position = gl_ProjectionMatrix * position;
	color = gl_Color;
	lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
	texcoord = gl_MultiTexCoord0;
}
